"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _token = require("./token");

const FEDAUTHINFOID = {
  STSURL: 0x01,
  SPN: 0x02
};

function fedAuthInfoParser(parser, _options, callback) {
  parser.readUInt32LE(tokenLength => {
    parser.readBuffer(tokenLength, data => {
      let spn, stsurl;
      let offset = 0;
      const countOfInfoIDs = data.readUInt32LE(offset);
      offset += 4;

      for (let i = 0; i < countOfInfoIDs; i++) {
        const fedauthInfoID = data.readUInt8(offset);
        offset += 1;
        const fedAuthInfoDataLen = data.readUInt32LE(offset);
        offset += 4;
        const fedAuthInfoDataOffset = data.readUInt32LE(offset);
        offset += 4;

        switch (fedauthInfoID) {
          case FEDAUTHINFOID.SPN:
            spn = data.toString('ucs2', fedAuthInfoDataOffset, fedAuthInfoDataOffset + fedAuthInfoDataLen);
            break;

          case FEDAUTHINFOID.STSURL:
            stsurl = data.toString('ucs2', fedAuthInfoDataOffset, fedAuthInfoDataOffset + fedAuthInfoDataLen);
            break;
          // ignoring unknown fedauthinfo options

          default:
            break;
        }
      }

      callback(new _token.FedAuthInfoToken(spn, stsurl));
    });
  });
}

var _default = fedAuthInfoParser;
exports.default = _default;
module.exports = fedAuthInfoParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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