"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _metadataParser = _interopRequireDefault(require("../metadata-parser"));

var _token = require("./token");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function readTableName(parser, options, metadata, callback) {
  if (metadata.type.hasTableName) {
    if (options.tdsVersion >= '7_2') {
      parser.readUInt8(numberOfTableNameParts => {
        const tableName = [];
        let i = 0;

        function next(done) {
          if (numberOfTableNameParts === i) {
            return done();
          }

          parser.readUsVarChar(part => {
            tableName.push(part);
            i++;
            next(done);
          });
        }

        next(() => {
          callback(tableName);
        });
      });
    } else {
      parser.readUsVarChar(callback);
    }
  } else {
    callback(undefined);
  }
}

function readColumnName(parser, options, index, metadata, callback) {
  parser.readBVarChar(colName => {
    if (options.columnNameReplacer) {
      callback(options.columnNameReplacer(colName, index, metadata));
    } else if (options.camelCaseColumns) {
      callback(colName.replace(/^[A-Z]/, function (s) {
        return s.toLowerCase();
      }));
    } else {
      callback(colName);
    }
  });
}

function readColumn(parser, options, index, callback) {
  (0, _metadataParser.default)(parser, options, metadata => {
    readTableName(parser, options, metadata, tableName => {
      readColumnName(parser, options, index, metadata, colName => {
        callback({
          userType: metadata.userType,
          flags: metadata.flags,
          type: metadata.type,
          collation: metadata.collation,
          precision: metadata.precision,
          scale: metadata.scale,
          udtInfo: metadata.udtInfo,
          dataLength: metadata.dataLength,
          schema: metadata.schema,
          colName: colName,
          tableName: tableName
        });
      });
    });
  });
}

async function colMetadataParser(parser) {
  while (parser.buffer.length - parser.position < 2) {
    await parser.streamBuffer.waitForChunk();
  }

  const columnCount = parser.buffer.readUInt16LE(parser.position);
  parser.position += 2;
  const columns = [];

  for (let i = 0; i < columnCount; i++) {
    let column;
    readColumn(parser, parser.options, i, c => {
      column = c;
    });

    while (parser.suspended) {
      await parser.streamBuffer.waitForChunk();
      parser.suspended = false;
      const next = parser.next;
      next();
    }

    columns.push(column);
  }

  return new _token.ColMetadataToken(columns);
}

var _default = colMetadataParser;
exports.default = _default;
module.exports = colMetadataParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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