"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.connect = connect;
Object.defineProperty(exports, "BulkLoad", {
  enumerable: true,
  get: function () {
    return _bulkLoad.default;
  }
});
Object.defineProperty(exports, "Connection", {
  enumerable: true,
  get: function () {
    return _connection.default;
  }
});
Object.defineProperty(exports, "Request", {
  enumerable: true,
  get: function () {
    return _request.default;
  }
});
Object.defineProperty(exports, "ConnectionError", {
  enumerable: true,
  get: function () {
    return _errors.ConnectionError;
  }
});
Object.defineProperty(exports, "RequestError", {
  enumerable: true,
  get: function () {
    return _errors.RequestError;
  }
});
Object.defineProperty(exports, "TYPES", {
  enumerable: true,
  get: function () {
    return _dataType.TYPES;
  }
});
Object.defineProperty(exports, "ISOLATION_LEVEL", {
  enumerable: true,
  get: function () {
    return _transaction.ISOLATION_LEVEL;
  }
});
Object.defineProperty(exports, "TDS_VERSION", {
  enumerable: true,
  get: function () {
    return _tdsVersions.versions;
  }
});
exports.library = void 0;

var _bulkLoad = _interopRequireDefault(require("./bulk-load"));

var _connection = _interopRequireDefault(require("./connection"));

var _request = _interopRequireDefault(require("./request"));

var _library = require("./library");

var _errors = require("./errors");

var _dataType = require("./data-type");

var _transaction = require("./transaction");

var _tdsVersions = require("./tds-versions");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const library = {
  name: _library.name
};
exports.library = library;

function connect(config, connectListener) {
  const connection = new _connection.default(config);
  connection.connect(connectListener);
  return connection;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uL3NyYy90ZWRpb3VzLnRzIl0sIm5hbWVzIjpbImxpYnJhcnkiLCJuYW1lIiwiY29ubmVjdCIsImNvbmZpZyIsImNvbm5lY3RMaXN0ZW5lciIsImNvbm5lY3Rpb24iLCJDb25uZWN0aW9uIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUFBOztBQUNBOztBQUNBOztBQUNBOztBQUVBOztBQUVBOztBQUNBOztBQUNBOzs7O0FBRUEsTUFBTUEsT0FBTyxHQUFHO0FBQUVDLEVBQUFBLElBQUksRUFBRUE7QUFBUixDQUFoQjs7O0FBRU8sU0FBU0MsT0FBVCxDQUFpQkMsTUFBakIsRUFBa0RDLGVBQWxELEVBQTJGO0FBQ2hHLFFBQU1DLFVBQVUsR0FBRyxJQUFJQyxtQkFBSixDQUFlSCxNQUFmLENBQW5CO0FBQ0FFLEVBQUFBLFVBQVUsQ0FBQ0gsT0FBWCxDQUFtQkUsZUFBbkI7QUFDQSxTQUFPQyxVQUFQO0FBQ0QiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgQnVsa0xvYWQgZnJvbSAnLi9idWxrLWxvYWQnO1xuaW1wb3J0IENvbm5lY3Rpb24sIHsgQ29ubmVjdGlvbkNvbmZpZ3VyYXRpb24gfSBmcm9tICcuL2Nvbm5lY3Rpb24nO1xuaW1wb3J0IFJlcXVlc3QgZnJvbSAnLi9yZXF1ZXN0JztcbmltcG9ydCB7IG5hbWUgfSBmcm9tICcuL2xpYnJhcnknO1xuXG5pbXBvcnQgeyBDb25uZWN0aW9uRXJyb3IsIFJlcXVlc3RFcnJvciB9IGZyb20gJy4vZXJyb3JzJztcblxuaW1wb3J0IHsgVFlQRVMgfSBmcm9tICcuL2RhdGEtdHlwZSc7XG5pbXBvcnQgeyBJU09MQVRJT05fTEVWRUwgfSBmcm9tICcuL3RyYW5zYWN0aW9uJztcbmltcG9ydCB7IHZlcnNpb25zIGFzIFREU19WRVJTSU9OIH0gZnJvbSAnLi90ZHMtdmVyc2lvbnMnO1xuXG5jb25zdCBsaWJyYXJ5ID0geyBuYW1lOiBuYW1lIH07XG5cbmV4cG9ydCBmdW5jdGlvbiBjb25uZWN0KGNvbmZpZzogQ29ubmVjdGlvbkNvbmZpZ3VyYXRpb24sIGNvbm5lY3RMaXN0ZW5lcj86IChlcnI/OiBFcnJvcikgPT4gdm9pZCkge1xuICBjb25zdCBjb25uZWN0aW9uID0gbmV3IENvbm5lY3Rpb24oY29uZmlnKTtcbiAgY29ubmVjdGlvbi5jb25uZWN0KGNvbm5lY3RMaXN0ZW5lcik7XG4gIHJldHVybiBjb25uZWN0aW9uO1xufVxuXG5leHBvcnQge1xuICBCdWxrTG9hZCxcbiAgQ29ubmVjdGlvbixcbiAgUmVxdWVzdCxcbiAgbGlicmFyeSxcbiAgQ29ubmVjdGlvbkVycm9yLFxuICBSZXF1ZXN0RXJyb3IsXG4gIFRZUEVTLFxuICBJU09MQVRJT05fTEVWRUwsXG4gIFREU19WRVJTSU9OXG59O1xuIl19