"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _writableTrackingBuffer = _interopRequireDefault(require("./tracking-buffer/writable-tracking-buffer"));

var _allHeaders = require("./all-headers");

let _Symbol$iterator;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// const OPTION = {
//   WITH_RECOMPILE: 0x01,
//   NO_METADATA: 0x02,
//   REUSE_METADATA: 0x04
// };
const STATUS = {
  BY_REF_VALUE: 0x01,
  DEFAULT_VALUE: 0x02
};
/*
  s2.2.6.5
 */

_Symbol$iterator = Symbol.iterator;

class RpcRequestPayload {
  constructor(procedure, parameters, txnDescriptor, options, collation) {
    this.procedure = void 0;
    this.parameters = void 0;
    this.options = void 0;
    this.txnDescriptor = void 0;
    this.collation = void 0;
    this.procedure = procedure;
    this.parameters = parameters;
    this.options = options;
    this.txnDescriptor = txnDescriptor;
    this.collation = collation;
  }

  [_Symbol$iterator]() {
    return this.generateData();
  }

  *generateData() {
    const buffer = new _writableTrackingBuffer.default(500);

    if (this.options.tdsVersion >= '7_2') {
      const outstandingRequestCount = 1;
      (0, _allHeaders.writeToTrackingBuffer)(buffer, this.txnDescriptor, outstandingRequestCount);
    }

    if (typeof this.procedure === 'string') {
      buffer.writeUsVarchar(this.procedure);
    } else {
      buffer.writeUShort(0xFFFF);
      buffer.writeUShort(this.procedure);
    }

    const optionFlags = 0;
    buffer.writeUInt16LE(optionFlags);
    yield buffer.data;
    const parametersLength = this.parameters.length;

    for (let i = 0; i < parametersLength; i++) {
      yield* this.generateParameterData(this.parameters[i]);
    }
  }

  toString(indent = '') {
    return indent + ('RPC Request - ' + this.procedure);
  }

  *generateParameterData(parameter) {
    const buffer = new _writableTrackingBuffer.default(1 + 2 + Buffer.byteLength(parameter.name, 'ucs-2') + 1);
    buffer.writeBVarchar('@' + parameter.name);
    let statusFlags = 0;

    if (parameter.output) {
      statusFlags |= STATUS.BY_REF_VALUE;
    }

    buffer.writeUInt8(statusFlags);
    yield buffer.data;
    const param = {
      value: parameter.value
    };
    const type = parameter.type;

    if ((type.id & 0x30) === 0x20) {
      if (parameter.length) {
        param.length = parameter.length;
      } else if (type.resolveLength) {
        param.length = type.resolveLength(parameter);
      }
    }

    if (parameter.precision) {
      param.precision = parameter.precision;
    } else if (type.resolvePrecision) {
      param.precision = type.resolvePrecision(parameter);
    }

    if (parameter.scale) {
      param.scale = parameter.scale;
    } else if (type.resolveScale) {
      param.scale = type.resolveScale(parameter);
    }

    if (this.collation) {
      param.collation = this.collation;
    }

    yield type.generateTypeInfo(param, this.options);
    yield type.generateParameterLength(param, this.options);
    yield* type.generateParameterData(param, this.options);
  }

}

var _default = RpcRequestPayload;
exports.default = _default;
module.exports = RpcRequestPayload;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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