"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _events = require("events");

var util = _interopRequireWildcard(require("util"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

class Debug extends _events.EventEmitter {
  /*
    @options    Which debug details should be sent.
                data    - dump of packet data
                payload - details of decoded payload
  */
  constructor({
    data = false,
    payload = false,
    packet = false,
    token = false
  } = {}) {
    super();
    this.options = void 0;
    this.indent = void 0;
    this.options = {
      data,
      payload,
      packet,
      token
    };
    this.indent = '  ';
  }

  packet(direction, packet) {
    if (this.haveListeners() && this.options.packet) {
      this.log('');
      this.log(direction);
      this.log(packet.headerToString(this.indent));
    }
  }

  data(packet) {
    if (this.haveListeners() && this.options.data) {
      this.log(packet.dataToString(this.indent));
    }
  }

  payload(generatePayloadText) {
    if (this.haveListeners() && this.options.payload) {
      this.log(generatePayloadText());
    }
  }

  token(token) {
    if (this.haveListeners() && this.options.token) {
      this.log(util.inspect(token, {
        showHidden: false,
        depth: 5,
        colors: true
      }));
    }
  }

  haveListeners() {
    return this.listeners('debug').length > 0;
  }

  log(text) {
    this.emit('debug', text);
  }

}

var _default = Debug;
exports.default = _default;
module.exports = Debug;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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