"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _guidParser = require("../guid-parser");

const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x10]);
const UniqueIdentifier = {
  id: 0x24,
  type: 'GUIDN',
  name: 'UniqueIdentifier',
  declaration: function () {
    return 'uniqueidentifier';
  },
  resolveLength: function () {
    return 16;
  },

  generateTypeInfo() {
    return Buffer.from([this.id, 0x10]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield Buffer.from((0, _guidParser.guidToArray)(parameter.value));
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'string') {
      throw new TypeError('Invalid string.');
    }

    if (!/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i.test(value)) {
      throw new TypeError('Invalid GUID.');
    }

    return value;
  }
};
var _default = UniqueIdentifier;
exports.default = _default;
module.exports = UniqueIdentifier;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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