"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const TVP_ROW_TOKEN = Buffer.from([0x01]);
const TVP_END_TOKEN = Buffer.from([0x00]);
const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const TVP = {
  id: 0xF3,
  type: 'TVPTYPE',
  name: 'TVP',
  declaration: function (parameter) {
    const value = parameter.value; // Temporary solution. Remove 'any' later.

    return value.name + ' readonly';
  },

  generateTypeInfo(parameter) {
    var _parameter$value$sche, _parameter$value, _parameter$value$name, _parameter$value2;

    const databaseName = '';
    const schema = (_parameter$value$sche = (_parameter$value = parameter.value) === null || _parameter$value === void 0 ? void 0 : _parameter$value.schema) !== null && _parameter$value$sche !== void 0 ? _parameter$value$sche : '';
    const typeName = (_parameter$value$name = (_parameter$value2 = parameter.value) === null || _parameter$value2 === void 0 ? void 0 : _parameter$value2.name) !== null && _parameter$value$name !== void 0 ? _parameter$value$name : '';
    const bufferLength = 1 + 1 + Buffer.byteLength(databaseName, 'ucs2') + 1 + Buffer.byteLength(schema, 'ucs2') + 1 + Buffer.byteLength(typeName, 'ucs2');
    const buffer = new _writableTrackingBuffer.default(bufferLength, 'ucs2');
    buffer.writeUInt8(this.id);
    buffer.writeBVarchar(databaseName);
    buffer.writeBVarchar(schema);
    buffer.writeBVarchar(typeName);
    return buffer.data;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const {
      columns
    } = parameter.value;
    const buffer = Buffer.alloc(2);
    buffer.writeUInt16LE(columns.length, 0);
    return buffer;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      yield TVP_END_TOKEN;
      yield TVP_END_TOKEN;
      return;
    }

    const {
      columns,
      rows
    } = parameter.value;

    for (let i = 0, len = columns.length; i < len; i++) {
      const column = columns[i];
      const buff = Buffer.alloc(6); // UserType

      buff.writeUInt32LE(0x00000000, 0); // Flags

      buff.writeUInt16LE(0x0000, 4);
      yield buff; // TYPE_INFO

      yield column.type.generateTypeInfo(column); // ColName

      yield Buffer.from([0x00]);
    }

    yield TVP_END_TOKEN;

    for (let i = 0, length = rows.length; i < length; i++) {
      yield TVP_ROW_TOKEN;
      const row = rows[i];

      for (let k = 0, len2 = row.length; k < len2; k++) {
        const column = columns[k];
        const value = row[k];
        const param = {
          value: column.type.validate(value, parameter.collation),
          length: column.length,
          scale: column.scale,
          precision: column.precision
        }; // TvpColumnData

        yield column.type.generateParameterLength(param, options);
        yield* column.type.generateParameterData(param, options);
      }
    }

    yield TVP_END_TOKEN;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (typeof value !== 'object') {
      throw new TypeError('Invalid table.');
    }

    if (!Array.isArray(value.columns)) {
      throw new TypeError('Invalid table.');
    }

    if (!Array.isArray(value.rows)) {
      throw new TypeError('Invalid table.');
    }

    return value;
  }
};
var _default = TVP;
exports.default = _default;
module.exports = TVP;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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