"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _datetimen = _interopRequireDefault(require("./datetimen"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const EPOCH_DATE = new Date(1900, 0, 1);
const UTC_EPOCH_DATE = new Date(Date.UTC(1900, 0, 1));
const DATA_LENGTH = Buffer.from([0x04]);
const NULL_LENGTH = Buffer.from([0x00]);
const SmallDateTime = {
  id: 0x3A,
  type: 'DATETIM4',
  name: 'SmallDateTime',
  declaration: function () {
    return 'smalldatetime';
  },

  generateTypeInfo() {
    return Buffer.from([_datetimen.default.id, 0x04]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  generateParameterData: function* (parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(4);
    let days, dstDiff, minutes;

    if (options.useUTC) {
      days = Math.floor((parameter.value.getTime() - UTC_EPOCH_DATE.getTime()) / (1000 * 60 * 60 * 24));
      minutes = parameter.value.getUTCHours() * 60 + parameter.value.getUTCMinutes();
    } else {
      dstDiff = -(parameter.value.getTimezoneOffset() - EPOCH_DATE.getTimezoneOffset()) * 60 * 1000;
      days = Math.floor((parameter.value.getTime() - EPOCH_DATE.getTime() + dstDiff) / (1000 * 60 * 60 * 24));
      minutes = parameter.value.getHours() * 60 + parameter.value.getMinutes();
    }

    buffer.writeUInt16LE(days, 0);
    buffer.writeUInt16LE(minutes, 2);
    yield buffer;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!(value instanceof Date)) {
      value = new Date(Date.parse(value));
    }

    if (isNaN(value)) {
      throw new TypeError('Invalid date.');
    }

    return value;
  }
};
var _default = SmallDateTime;
exports.default = _default;
module.exports = SmallDateTime;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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