"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _floatn = _interopRequireDefault(require("./floatn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x04]);
const Real = {
  id: 0x3B,
  type: 'FLT4',
  name: 'Real',
  declaration: function () {
    return 'real';
  },

  generateTypeInfo() {
    return Buffer.from([_floatn.default.id, 0x04]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeFloatLE(parseFloat(parameter.value), 0);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    return value;
  }
};
var _default = Real;
exports.default = _default;
module.exports = Real;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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