"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _moneyn = _interopRequireDefault(require("./moneyn"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const SHIFT_LEFT_32 = (1 << 16) * (1 << 16);
const SHIFT_RIGHT_32 = 1 / SHIFT_LEFT_32;
const NULL_LENGTH = Buffer.from([0x00]);
const DATA_LENGTH = Buffer.from([0x08]);
const Money = {
  id: 0x3C,
  type: 'MONEY',
  name: 'Money',
  declaration: function () {
    return 'money';
  },
  generateTypeInfo: function () {
    return Buffer.from([_moneyn.default.id, 0x08]);
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    return DATA_LENGTH;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    const value = parameter.value * 10000;
    const buffer = Buffer.alloc(8);
    buffer.writeInt32LE(Math.floor(value * SHIFT_RIGHT_32), 0);
    buffer.writeInt32LE(value & -1, 4);
    yield buffer;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    value = parseFloat(value);

    if (isNaN(value)) {
      throw new TypeError('Invalid number.');
    }

    return value;
  }
};
var _default = Money;
exports.default = _default;
module.exports = Money;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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