"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const NULL_LENGTH = Buffer.from([0xFF, 0xFF, 0xFF, 0xFF]);
const Image = {
  id: 0x22,
  type: 'IMAGE',
  name: 'Image',
  hasTableName: true,
  declaration: function () {
    return 'image';
  },
  resolveLength: function (parameter) {
    if (parameter.value != null) {
      const value = parameter.value; // TODO: Temporary solution. Replace 'any' more with specific type;

      return value.length;
    } else {
      return -1;
    }
  },

  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(5);
    buffer.writeUInt8(this.id, 0);
    buffer.writeInt32LE(parameter.length, 1);
    return buffer;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(4);
    buffer.writeInt32LE(parameter.value.length, 0);
    return buffer;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield parameter.value;
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!Buffer.isBuffer(value)) {
      throw new TypeError('Invalid buffer.');
    }

    return value;
  }
};
var _default = Image;
exports.default = _default;
module.exports = Image;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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