"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
const NULL_LENGTH = Buffer.from([0xFF, 0xFF]);
const Binary = {
  id: 0xAD,
  type: 'BIGBinary',
  name: 'Binary',
  maximumLength: 8000,
  declaration: function (parameter) {
    const value = parameter.value;
    let length;

    if (parameter.length) {
      length = parameter.length;
    } else if (value != null) {
      length = value.length || 1;
    } else if (value === null && !parameter.output) {
      length = 1;
    } else {
      length = this.maximumLength;
    }

    return 'binary(' + length + ')';
  },
  resolveLength: function (parameter) {
    const value = parameter.value;

    if (value != null) {
      return value.length;
    } else {
      return this.maximumLength;
    }
  },

  generateTypeInfo(parameter) {
    const buffer = Buffer.alloc(3);
    buffer.writeUInt8(this.id, 0);
    buffer.writeUInt16LE(parameter.length, 1);
    return buffer;
  },

  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }

    const buffer = Buffer.alloc(2);
    buffer.writeUInt16LE(parameter.length, 0);
    return buffer;
  },

  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }

    yield parameter.value.slice(0, parameter.length !== undefined ? Math.min(parameter.length, this.maximumLength) : this.maximumLength);
  },

  validate: function (value) {
    if (value == null) {
      return null;
    }

    if (!Buffer.isBuffer(value)) {
      throw new TypeError('Invalid buffer.');
    }

    return value;
  }
};
var _default = Binary;
exports.default = _default;
module.exports = Binary;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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