// Copyright (c) Microsoft Corporation.
// Licensed under the MIT license.
import { DeveloperSignOnClientId } from "../constants";
import { checkTenantId } from "./checkTenantId";
export function resolveTenantId(logger, tenantId, clientId) {
    if (tenantId) {
        checkTenantId(logger, tenantId);
        return tenantId;
    }
    if (!clientId) {
        clientId = DeveloperSignOnClientId;
    }
    if (clientId !== DeveloperSignOnClientId) {
        return "common";
    }
    return "organizations";
}
//# sourceMappingURL=resolveTenantId.js.map