
Library IEEE ;
Use IEEE.Std_Logic_1164.All;
Use IEEE.Std_Logic_Unsigned.All;

Entity AB_INIT_CONFIG Is
         
    Port(
        SYS_CLK   : In  Std_Logic;
        SYS_RST   : In  Std_Logic;
        INIT_RUN  : In  Std_Logic;
        INIT_DONE : Out Std_Logic;
        ACMCLK    : Out Std_Logic;
        ACMWE     : Out Std_Logic;
        ACMADDR   : Out Std_Logic_Vector( 7 DownTo 0 );
        ACMWDATA  : Out Std_Logic_Vector( 7 DownTo 0 )
        );

End AB_INIT_CONFIG;

Architecture RTL Of AB_INIT_CONFIG Is

    Type State_Value Is Range 0 To 41;
    Signal State          : State_Value;
    Signal Next_State     : State_Value;
    Signal Int_Iinit_Done : Std_Logic;

Begin

    Process( SYS_CLK, SYS_RST )
    Begin
        If ( SYS_RST = '1' ) Then
            ACMWE <= '0';
        ElsIf Rising_Edge( SYS_CLK ) Then
            If ( INIT_RUN = '1' )  Then
                ACMWE <= '1';
            ElsIf Int_Iinit_Done='1' Then
                ACMWE <= '0';
            End If;
        End If;
    End Process;

    Process( SYS_CLK, INIT_RUN, SYS_RST )
    Begin
        If ( SYS_RST = '1' ) Then
            State <= 0;
        ElsIf Rising_Edge( SYS_CLK ) Then
            State <= Next_State;
        End If;
    End Process;

    Process( State, INIT_RUN )
    Begin

        Next_State    <= 0;

        Case State Is

            When 0    => ACMADDR <= "00000000"; ACMWDATA <= "00000000";
                         If ( INIT_RUN = '1' ) Then
                            Next_State <= 1 ;
                         End If;
            When 1    => ACMADDR <= "00000001"; ACMWDATA <= "ReplaceWith_AV0"; Next_State <= 2 ;
            When 2    => ACMADDR <= "00000010"; ACMWDATA <= "ReplaceWith_AC0"; Next_State <= 3 ;
            When 3    => ACMADDR <= "00000011"; ACMWDATA <= "ReplaceWith_AT0"; Next_State <= 4 ;
            When 4    => ACMADDR <= "00000100"; ACMWDATA <= "ReplaceWith_AG0"; Next_State <= 5 ;
            When 5    => ACMADDR <= "00000101"; ACMWDATA <= "ReplaceWith_AV1"; Next_State <= 6 ;
            When 6    => ACMADDR <= "00000110"; ACMWDATA <= "ReplaceWith_AC1"; Next_State <= 7 ;
            When 7    => ACMADDR <= "00000111"; ACMWDATA <= "ReplaceWith_AT1"; Next_State <= 8 ;
            When 8    => ACMADDR <= "00001000"; ACMWDATA <= "ReplaceWith_AG1"; Next_State <= 9 ;
            When 9    => ACMADDR <= "00001001"; ACMWDATA <= "ReplaceWith_AV2"; Next_State <= 10;
            When 10   => ACMADDR <= "00001010"; ACMWDATA <= "ReplaceWith_AC2"; Next_State <= 11;
            When 11   => ACMADDR <= "00001011"; ACMWDATA <= "ReplaceWith_AT2"; Next_State <= 12;
            When 12   => ACMADDR <= "00001100"; ACMWDATA <= "ReplaceWith_AG2"; Next_State <= 13;
            When 13   => ACMADDR <= "00001101"; ACMWDATA <= "ReplaceWith_AV3"; Next_State <= 14;
            When 14   => ACMADDR <= "00001110"; ACMWDATA <= "ReplaceWith_AC3"; Next_State <= 15;
            When 15   => ACMADDR <= "00001111"; ACMWDATA <= "ReplaceWith_AT3"; Next_State <= 16;
            When 16   => ACMADDR <= "00010000"; ACMWDATA <= "ReplaceWith_AG3"; Next_State <= 17;
            When 17   => ACMADDR <= "00010001"; ACMWDATA <= "ReplaceWith_AV4"; Next_State <= 18;
            When 18   => ACMADDR <= "00010010"; ACMWDATA <= "ReplaceWith_AC4"; Next_State <= 19;
            When 19   => ACMADDR <= "00010011"; ACMWDATA <= "ReplaceWith_AT4"; Next_State <= 20;
            When 20   => ACMADDR <= "00010100"; ACMWDATA <= "ReplaceWith_AG4"; Next_State <= 21;
            When 21   => ACMADDR <= "00010101"; ACMWDATA <= "ReplaceWith_AV5"; Next_State <= 22;
            When 22   => ACMADDR <= "00010110"; ACMWDATA <= "ReplaceWith_AC5"; Next_State <= 23;
            When 23   => ACMADDR <= "00010111"; ACMWDATA <= "ReplaceWith_AT5"; Next_State <= 24;
            When 24   => ACMADDR <= "00011000"; ACMWDATA <= "ReplaceWith_AG5"; Next_State <= 25;
            When 25   => ACMADDR <= "00011001"; ACMWDATA <= "ReplaceWith_AV6"; Next_State <= 26;
            When 26   => ACMADDR <= "00011010"; ACMWDATA <= "ReplaceWith_AC6"; Next_State <= 27;
            When 27   => ACMADDR <= "00011011"; ACMWDATA <= "ReplaceWith_AT6"; Next_State <= 28;
            When 28   => ACMADDR <= "00011100"; ACMWDATA <= "ReplaceWith_AG6"; Next_State <= 29;
            When 29   => ACMADDR <= "00011101"; ACMWDATA <= "ReplaceWith_AV7"; Next_State <= 30;
            When 30   => ACMADDR <= "00011110"; ACMWDATA <= "ReplaceWith_AC7"; Next_State <= 31;
            When 31   => ACMADDR <= "00011111"; ACMWDATA <= "ReplaceWith_AT7"; Next_State <= 32;
            When 32   => ACMADDR <= "00100000"; ACMWDATA <= "ReplaceWith_AG7"; Next_State <= 33;
            When 33   => ACMADDR <= "00100001"; ACMWDATA <= "ReplaceWith_AV8"; Next_State <= 34;
            When 34   => ACMADDR <= "00100010"; ACMWDATA <= "ReplaceWith_AC8"; Next_State <= 35;
            When 35   => ACMADDR <= "00100011"; ACMWDATA <= "ReplaceWith_AT8"; Next_State <= 36;
            When 36   => ACMADDR <= "00100100"; ACMWDATA <= "ReplaceWith_AG8"; Next_State <= 37;
            When 37   => ACMADDR <= "00100101"; ACMWDATA <= "ReplaceWith_AV9"; Next_State <= 38;
            When 38   => ACMADDR <= "00100110"; ACMWDATA <= "ReplaceWith_AC9"; Next_State <= 39;
            When 39   => ACMADDR <= "00100111"; ACMWDATA <= "ReplaceWith_AT9"; Next_State <= 40;
            When 40   => ACMADDR <= "00101000"; ACMWDATA <= "ReplaceWith_AG9"; Next_State <= 41;

            When 41   => ACMADDR <= "00000000"; ACMWDATA <= "00000000"; Next_State <= 41;

            When Others => Next_State <= 0;
        End Case;
    End Process;

    Process( SYS_CLK, SYS_RST)
    Begin
        If ( SYS_RST = '1' ) Then
            Int_Iinit_Done <= '0';
        ElsIf Rising_Edge( SYS_CLK ) Then
            If State = 41 Then
                Int_Iinit_Done <= '1';
            Else
                Int_Iinit_Done <= '0';
            End If;
        End If;
    End Process;

    ACMCLK    <= SYS_CLK;
    INIT_DONE <= Int_Iinit_Done;

End RTL;

Library IEEE ;
Use IEEE.Std_Logic_1164.All;
Use IEEE.Std_Logic_Unsigned.All;
library fusion;

entity Configurable_ReplaceWith_Designator is
    port (
        AV0        : In    Std_Logic;                                           -- ExcludeIf_NotAV0
        AC0        : In    Std_Logic;                                           -- ExcludeIf_NotAC0
        AT0        : In    Std_Logic;                                           -- ExcludeIf_NotAT0
        AG0        : Out   Std_Logic;                                           -- ExcludeIf_NotAG0
        GDON0      : In    Std_Logic;                                           -- ExcludeIf_NotAG0
        AV1        : In    Std_Logic;                                           -- ExcludeIf_NotAV1
        AC1        : In    Std_Logic;                                           -- ExcludeIf_NotAC1
        AT1        : In    Std_Logic;                                           -- ExcludeIf_NotAT1
        AG1        : Out   Std_Logic;                                           -- ExcludeIf_NotAG1
        GDON1      : In    Std_Logic;                                           -- ExcludeIf_NotAG1
        AV2        : In    Std_Logic;                                           -- ExcludeIf_NotAV2
        AC2        : In    Std_Logic;                                           -- ExcludeIf_NotAC2
        AT2        : In    Std_Logic;                                           -- ExcludeIf_NotAT2
        AG2        : Out   Std_Logic;                                           -- ExcludeIf_NotAG2
        GDON2      : In    Std_Logic;                                           -- ExcludeIf_NotAG2
        AV3        : In    Std_Logic;                                           -- ExcludeIf_NotAV3
        AC3        : In    Std_Logic;                                           -- ExcludeIf_NotAC3
        AT3        : In    Std_Logic;                                           -- ExcludeIf_NotAT3
        AG3        : Out   Std_Logic;                                           -- ExcludeIf_NotAG3
        GDON3      : In    Std_Logic;                                           -- ExcludeIf_NotAG3
        AV4        : In    Std_Logic;                                           -- ExcludeIf_NotAV4
        AC4        : In    Std_Logic;                                           -- ExcludeIf_NotAC4
        AT4        : In    Std_Logic;                                           -- ExcludeIf_NotAT4
        AG4        : Out   Std_Logic;                                           -- ExcludeIf_NotAG4
        GDON4      : In    Std_Logic;                                           -- ExcludeIf_NotAG4
        AV5        : In    Std_Logic;                                           -- ExcludeIf_NotAV5
        AC5        : In    Std_Logic;                                           -- ExcludeIf_NotAC5
        AT5        : In    Std_Logic;                                           -- ExcludeIf_NotAT5
        AG5        : Out   Std_Logic;                                           -- ExcludeIf_NotAG5
        GDON5      : In    Std_Logic;                                           -- ExcludeIf_NotAG5
        AV6        : In    Std_Logic;                                           -- ExcludeIf_NotAV6
        AC6        : In    Std_Logic;                                           -- ExcludeIf_NotAC6
        AT6        : In    Std_Logic;                                           -- ExcludeIf_NotAT6
        AG6        : Out   Std_Logic;                                           -- ExcludeIf_NotAG6
        GDON6      : In    Std_Logic;                                           -- ExcludeIf_NotAG6
        AV7        : In    Std_Logic;                                           -- ExcludeIf_NotAV7
        AC7        : In    Std_Logic;                                           -- ExcludeIf_NotAC7
        AT7        : In    Std_Logic;                                           -- ExcludeIf_NotAT7
        AG7        : Out   Std_Logic;                                           -- ExcludeIf_NotAG7
        GDON7      : In    Std_Logic;                                           -- ExcludeIf_NotAG7
        AV8        : In    Std_Logic;                                           -- ExcludeIf_NotAV8
        AC8        : In    Std_Logic;                                           -- ExcludeIf_NotAC8
        AT8        : In    Std_Logic;                                           -- ExcludeIf_NotAT8
        AG8        : Out   Std_Logic;                                           -- ExcludeIf_NotAG8
        GDON8      : In    Std_Logic;                                           -- ExcludeIf_NotAG8
        AV9        : In    Std_Logic;                                           -- ExcludeIf_NotAV9
        AC9        : In    Std_Logic;                                           -- ExcludeIf_NotAC9
        AT9        : In    Std_Logic;                                           -- ExcludeIf_NotAT9
        AG9        : Out   Std_Logic;                                           -- ExcludeIf_NotAG9
        GDON9      : In    Std_Logic;                                           -- ExcludeIf_NotAG9
        ATRET01    : In    Std_Logic;                                           -- ExcludeIf_NotATRET01
        ATRET23    : In    Std_Logic;                                           -- ExcludeIf_NotATRET23
        ATRET45    : In    Std_Logic;                                           -- ExcludeIf_NotATRET45
        ATRET67    : In    Std_Logic;                                           -- ExcludeIf_NotATRET67
        ATRET89    : In    Std_Logic;                                           -- ExcludeIf_NotATRET89
        DAVOUT0    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT0
        DACOUT0    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT0
        DATOUT0    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT0
        DAVOUT1    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT1
        DACOUT1    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT1
        DATOUT1    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT1
        DAVOUT2    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT2
        DACOUT2    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT2
        DATOUT2    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT2
        DAVOUT3    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT3
        DACOUT3    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT3
        DATOUT3    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT3
        DAVOUT4    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT4
        DACOUT4    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT4
        DATOUT4    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT4
        DAVOUT5    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT5
        DACOUT5    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT5
        DATOUT5    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT5
        DAVOUT6    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT6
        DACOUT6    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT6
        DATOUT6    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT6
        DAVOUT7    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT7
        DACOUT7    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT7
        DATOUT7    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT7
        DAVOUT8    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT8
        DACOUT8    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT8
        DATOUT8    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT8
        DAVOUT9    : Out   Std_Logic;                                           -- ExcludeIf_NotDAVOUT9
        DACOUT9    : Out   Std_Logic;                                           -- ExcludeIf_NotDACOUT9
        DATOUT9    : Out   Std_Logic;                                           -- ExcludeIf_NotDATOUT9
        VAREF      : InOut Std_Logic;
        GNDREF     : In    Std_Logic;                                           -- ExcludeIf_NotExternalVref
        SYS_CLK    : In    Std_Logic;
        SYS_RST    : In    Std_Logic;
        RESULT     : Out   Std_Logic_Vector( 11 DownTo 0 );
        READY      : Out   Std_Logic;
        CH_NUMBER  : In    Std_Logic_Vector(  4 DownTo 0 );
        ADC_DONE   : Out   Std_Logic;
        ADC_START  : In    Std_Logic
    );
end Configurable_ReplaceWith_Designator;

Architecture RTL Of Configurable_ReplaceWith_Designator Is

    Component AB
        Port(
            DAVOUT0     : Out   Std_Logic;
            DACOUT0     : Out   Std_Logic;
            DATOUT0     : Out   Std_Logic;
            DAVOUT1     : Out   Std_Logic;
            DACOUT1     : Out   Std_Logic;
            DATOUT1     : Out   Std_Logic;
            DAVOUT2     : Out   Std_Logic;
            DACOUT2     : Out   Std_Logic;
            DATOUT2     : Out   Std_Logic;
            DAVOUT3     : Out   Std_Logic;
            DACOUT3     : Out   Std_Logic;
            DATOUT3     : Out   Std_Logic;
            DAVOUT4     : Out   Std_Logic;
            DACOUT4     : Out   Std_Logic;
            DATOUT4     : Out   Std_Logic;
            DAVOUT5     : Out   Std_Logic;
            DACOUT5     : Out   Std_Logic;
            DATOUT5     : Out   Std_Logic;
            DAVOUT6     : Out   Std_Logic;
            DACOUT6     : Out   Std_Logic;
            DATOUT6     : Out   Std_Logic;
            DAVOUT7     : Out   Std_Logic;
            DACOUT7     : Out   Std_Logic;
            DATOUT7     : Out   Std_Logic;
            DAVOUT8     : Out   Std_Logic;
            DACOUT8     : Out   Std_Logic;
            DATOUT8     : Out   Std_Logic;
            DAVOUT9     : Out   Std_Logic;
            DACOUT9     : Out   Std_Logic;
            DATOUT9     : Out   Std_Logic;
            DENAV0      : In    Std_Logic;
            DENAC0      : In    Std_Logic;
            DENAT0      : In    Std_Logic;
            DENAV1      : In    Std_Logic;
            DENAC1      : In    Std_Logic;
            DENAT1      : In    Std_Logic;
            DENAV2      : In    Std_Logic;
            DENAC2      : In    Std_Logic;
            DENAT2      : In    Std_Logic;
            DENAV3      : In    Std_Logic;
            DENAC3      : In    Std_Logic;
            DENAT3      : In    Std_Logic;
            DENAV4      : In    Std_Logic;
            DENAC4      : In    Std_Logic;
            DENAT4      : In    Std_Logic;
            DENAV5      : In    Std_Logic;
            DENAC5      : In    Std_Logic;
            DENAT5      : In    Std_Logic;
            DENAV6      : In    Std_Logic;
            DENAC6      : In    Std_Logic;
            DENAT6      : In    Std_Logic;
            DENAV7      : In    Std_Logic;
            DENAC7      : In    Std_Logic;
            DENAT7      : In    Std_Logic;
            DENAV8      : In    Std_Logic;
            DENAC8      : In    Std_Logic;
            DENAT8      : In    Std_Logic;
            DENAV9      : In    Std_Logic;
            DENAC9      : In    Std_Logic;
            DENAT9      : In    Std_Logic;
            AV0         : In    Std_Logic;
            AC0         : In    Std_Logic;
            AT0         : In    Std_Logic;
            AG0         : Out   Std_Logic;
            AV1         : In    Std_Logic;
            AC1         : In    Std_Logic;
            AT1         : In    Std_Logic;
            AG1         : Out   Std_Logic;
            AV2         : In    Std_Logic;
            AC2         : In    Std_Logic;
            AT2         : In    Std_Logic;
            AG2         : Out   Std_Logic;
            AV3         : In    Std_Logic;
            AC3         : In    Std_Logic;
            AT3         : In    Std_Logic;
            AG3         : Out   Std_Logic;
            AV4         : In    Std_Logic;
            AC4         : In    Std_Logic;
            AT4         : In    Std_Logic;
            AG4         : Out   Std_Logic;
            AV5         : In    Std_Logic;
            AC5         : In    Std_Logic;
            AT5         : In    Std_Logic;
            AG5         : Out   Std_Logic;
            AV6         : In    Std_Logic;
            AC6         : In    Std_Logic;
            AT6         : In    Std_Logic;
            AG6         : Out   Std_Logic;
            AV7         : In    Std_Logic;
            AC7         : In    Std_Logic;
            AT7         : In    Std_Logic;
            AG7         : Out   Std_Logic;
            AV8         : In    Std_Logic;
            AC8         : In    Std_Logic;
            AT8         : In    Std_Logic;
            AG8         : Out   Std_Logic;
            AV9         : In    Std_Logic;
            AC9         : In    Std_Logic;
            AT9         : In    Std_Logic;
            AG9         : Out   Std_Logic;
            ATRETURN01  : In    Std_Logic;
            ATRETURN23  : In    Std_Logic;
            ATRETURN45  : In    Std_Logic;
            ATRETURN67  : In    Std_Logic;
            ATRETURN89  : In    Std_Logic;
            VAREF       : InOut Std_Logic;
            GNDREF      : In    Std_Logic;
            GDON0       : In    Std_Logic;
            GDON1       : In    Std_Logic;
            GDON2       : In    Std_Logic;
            GDON3       : In    Std_Logic;
            GDON4       : In    Std_Logic;
            GDON5       : In    Std_Logic;
            GDON6       : In    Std_Logic;
            GDON7       : In    Std_Logic;
            GDON8       : In    Std_Logic;
            GDON9       : In    Std_Logic;
            CMSTB0      : In    Std_Logic;
            CMSTB1      : In    Std_Logic;
            CMSTB2      : In    Std_Logic;
            CMSTB3      : In    Std_Logic;
            CMSTB4      : In    Std_Logic;
            CMSTB5      : In    Std_Logic;
            CMSTB6      : In    Std_Logic;
            CMSTB7      : In    Std_Logic;
            CMSTB8      : In    Std_Logic;
            CMSTB9      : In    Std_Logic;
            TMSTB0      : In    Std_Logic;
            TMSTB1      : In    Std_Logic;
            TMSTB2      : In    Std_Logic;
            TMSTB3      : In    Std_Logic;
            TMSTB4      : In    Std_Logic;
            TMSTB5      : In    Std_Logic;
            TMSTB6      : In    Std_Logic;
            TMSTB7      : In    Std_Logic;
            TMSTB8      : In    Std_Logic;
            TMSTB9      : In    Std_Logic;
            TMSTBINT    : In    Std_Logic;
            RESULT      : Out   Std_Logic_Vector(11 DownTo 0);
            ACMRDATA    : Out   Std_Logic_Vector( 7 DownTo 0);
            ACMWDATA    : In    Std_Logic_Vector( 7 DownTo 0);
            ACMADDR     : In    Std_Logic_Vector( 7 DownTo 0);
            STC         : In    Std_Logic_Vector( 7 DownTo 0);
            TVC         : In    Std_Logic_Vector( 7 DownTo 0);
            CHNUMBER    : In    Std_Logic_Vector( 4 DownTo 0);
            MODE        : In    Std_Logic_Vector( 3 DownTo 0);
            RTCXTLMODE  : Out   Std_Logic_Vector( 1 DownTo 0);
            ACMRESET    : In    Std_Logic;
            ACMCLK      : In    Std_Logic;
            ACMWEN      : In    Std_Logic;
            VAREFSEL    : In    Std_Logic;
            DATAVALID   : Out   Std_Logic;
            CALIBRATE   : Out   Std_Logic;
            SAMPLE      : Out   Std_Logic;
            BUSY        : Out   Std_Logic;
            PWRDWN      : In    Std_Logic;
            SYSCLK      : In    Std_Logic;
            ADCRESET    : In    Std_Logic;
            ADCSTART    : In    Std_Logic;
            RTCMATCH    : Out   Std_Logic;
            RTCPSMMATCH : Out   Std_Logic;
            RTCXTLSEL   : Out   Std_Logic;
            RTCCLK      : In    Std_Logic
            );
    End Component;

    Component AB_INIT_CONFIG
        Port(
            SYS_CLK   : In  Std_Logic;
            SYS_RST   : In  Std_Logic;
            INIT_RUN  : In  Std_Logic;
            INIT_DONE : Out Std_Logic;
            ACMCLK    : Out Std_Logic;
            ACMWE     : Out Std_Logic;
            ACMADDR   : Out Std_Logic_Vector( 7 DownTo 0 );
            ACMWDATA  : Out Std_Logic_Vector( 7 DownTo 0 )
            );
    End Component;

    Type State_Value Is ( Idle, Init_Sys, Cap_Data );
    Signal State          : State_Value;
    Signal Next_State     : State_Value;
    Signal Int_ACMCLK     : Std_Logic;
    Signal Int_ACMRESET   : Std_Logic;
    Signal Int_ACMWE      : Std_Logic;
    Signal Int_ACMADDR    : Std_Logic_Vector(  7 DownTo 0 );
    Signal Int_ACMWDATA   : Std_Logic_Vector(  7 DownTo 0 );
    Signal Int_Init_Run   : Std_Logic;
    Signal Int_Init_Done  : Std_Logic;
    Signal Int_Count      : Std_Logic_Vector( 12 DownTo 0 );
    Signal Int_Next_Count : Std_Logic_Vector( 12 DownTo 0 );
    Signal Int_Sys_Start  : Std_Logic;
    Signal Int_ADCSTART   : Std_Logic;
    Signal Int_ADCSTART1  : Std_Logic;
    Signal Int_ADCSTART2  : Std_Logic;

Begin

    Int_ACMRESET <= Not SYS_RST;

    AB_INST : AB
    Port map(

        DAVOUT0       => DAVOUT0,                                               -- ExcludeIf_NotDAVOUT0
        DAVOUT0       => OPEN,                                                  -- ExcludeIf_DAVOUT0
        DACOUT0       => DACOUT0,                                               -- ExcludeIf_NotDACOUT0
        DACOUT0       => OPEN,                                                  -- ExcludeIf_DACOUT0
        DATOUT0       => DATOUT0,                                               -- ExcludeIf_NotDATOUT0
        DATOUT0       => OPEN,                                                  -- ExcludeIf_DATOUT0
        DAVOUT1       => DAVOUT1,                                               -- ExcludeIf_NotDAVOUT1
        DAVOUT1       => OPEN,                                                  -- ExcludeIf_DAVOUT1
        DACOUT1       => DACOUT1,                                               -- ExcludeIf_NotDACOUT1
        DACOUT1       => OPEN,                                                  -- ExcludeIf_DACOUT1
        DATOUT1       => DATOUT1,                                               -- ExcludeIf_NotDATOUT1
        DATOUT1       => OPEN,                                                  -- ExcludeIf_DATOUT1
        DAVOUT2       => DAVOUT2,                                               -- ExcludeIf_NotDAVOUT2
        DAVOUT2       => OPEN,                                                  -- ExcludeIf_DAVOUT2
        DACOUT2       => DACOUT2,                                               -- ExcludeIf_NotDACOUT2
        DACOUT2       => OPEN,                                                  -- ExcludeIf_DACOUT2
        DATOUT2       => DATOUT2,                                               -- ExcludeIf_NotDATOUT2
        DATOUT2       => OPEN,                                                  -- ExcludeIf_DATOUT2
        DAVOUT3       => DAVOUT3,                                               -- ExcludeIf_NotDAVOUT3
        DAVOUT3       => OPEN,                                                  -- ExcludeIf_DAVOUT3
        DACOUT3       => DACOUT3,                                               -- ExcludeIf_NotDACOUT3
        DACOUT3       => OPEN,                                                  -- ExcludeIf_DACOUT3
        DATOUT3       => DATOUT3,                                               -- ExcludeIf_NotDATOUT3
        DATOUT3       => OPEN,                                                  -- ExcludeIf_DATOUT3
        DAVOUT4       => DAVOUT4,                                               -- ExcludeIf_NotDAVOUT4
        DAVOUT4       => OPEN,                                                  -- ExcludeIf_DAVOUT4
        DACOUT4       => DACOUT4,                                               -- ExcludeIf_NotDACOUT4
        DACOUT4       => OPEN,                                                  -- ExcludeIf_DACOUT4
        DATOUT4       => DATOUT4,                                               -- ExcludeIf_NotDATOUT4
        DATOUT4       => OPEN,                                                  -- ExcludeIf_DATOUT4
        DAVOUT5       => DAVOUT5,                                               -- ExcludeIf_NotDAVOUT5
        DAVOUT5       => OPEN,                                                  -- ExcludeIf_DAVOUT5
        DACOUT5       => DACOUT5,                                               -- ExcludeIf_NotDACOUT5
        DACOUT5       => OPEN,                                                  -- ExcludeIf_DACOUT5
        DATOUT5       => DATOUT5,                                               -- ExcludeIf_NotDATOUT5
        DATOUT5       => OPEN,                                                  -- ExcludeIf_DATOUT5
        DAVOUT6       => DAVOUT6,                                               -- ExcludeIf_NotDAVOUT6
        DAVOUT6       => OPEN,                                                  -- ExcludeIf_DAVOUT6
        DACOUT6       => DACOUT6,                                               -- ExcludeIf_NotDACOUT6
        DACOUT6       => OPEN,                                                  -- ExcludeIf_DACOUT6
        DATOUT6       => DATOUT6,                                               -- ExcludeIf_NotDATOUT6
        DATOUT6       => OPEN,                                                  -- ExcludeIf_DATOUT6
        DAVOUT7       => DAVOUT7,                                               -- ExcludeIf_NotDAVOUT7
        DAVOUT7       => OPEN,                                                  -- ExcludeIf_DAVOUT7
        DACOUT7       => DACOUT7,                                               -- ExcludeIf_NotDACOUT7
        DACOUT7       => OPEN,                                                  -- ExcludeIf_DACOUT7
        DATOUT7       => DATOUT7,                                               -- ExcludeIf_NotDATOUT7
        DATOUT7       => OPEN,                                                  -- ExcludeIf_DATOUT7
        DAVOUT8       => DAVOUT8,                                               -- ExcludeIf_NotDAVOUT8
        DAVOUT8       => OPEN,                                                  -- ExcludeIf_DAVOUT8
        DACOUT8       => DACOUT8,                                               -- ExcludeIf_NotDACOUT8
        DACOUT8       => OPEN,                                                  -- ExcludeIf_DACOUT8
        DATOUT8       => DATOUT8,                                               -- ExcludeIf_NotDATOUT8
        DATOUT8       => OPEN,                                                  -- ExcludeIf_DATOUT8
        DAVOUT9       => DAVOUT9,                                               -- ExcludeIf_NotDAVOUT9
        DAVOUT9       => OPEN,                                                  -- ExcludeIf_DAVOUT9
        DACOUT9       => DACOUT9,                                               -- ExcludeIf_NotDACOUT9
        DACOUT9       => OPEN,                                                  -- ExcludeIf_DACOUT9
        DATOUT9       => DATOUT9,                                               -- ExcludeIf_NotDATOUT9
        DATOUT9       => OPEN,                                                  -- ExcludeIf_DATOUT9
        DENAV0        => '1',                                                   -- ExcludeIf_NotDAVOUT0
        DENAV0        => '0',                                                   -- ExcludeIf_DAVOUT0
        DENAC0        => '1',                                                   -- ExcludeIf_NotDACOUT0
        DENAC0        => '0',                                                   -- ExcludeIf_DACOUT0
        DENAT0        => '1',                                                   -- ExcludeIf_NotDATOUT0
        DENAT0        => '0',                                                   -- ExcludeIf_DATOUT0
        DENAV1        => '1',                                                   -- ExcludeIf_NotDAVOUT1
        DENAV1        => '0',                                                   -- ExcludeIf_DAVOUT1
        DENAC1        => '1',                                                   -- ExcludeIf_NotDACOUT1
        DENAC1        => '0',                                                   -- ExcludeIf_DACOUT1
        DENAT1        => '1',                                                   -- ExcludeIf_NotDATOUT1
        DENAT1        => '0',                                                   -- ExcludeIf_DATOUT1
        DENAV2        => '1',                                                   -- ExcludeIf_NotDAVOUT2
        DENAV2        => '0',                                                   -- ExcludeIf_DAVOUT2
        DENAC2        => '1',                                                   -- ExcludeIf_NotDACOUT2
        DENAC2        => '0',                                                   -- ExcludeIf_DACOUT2
        DENAT2        => '1',                                                   -- ExcludeIf_NotDATOUT2
        DENAT2        => '0',                                                   -- ExcludeIf_DATOUT2
        DENAV3        => '1',                                                   -- ExcludeIf_NotDAVOUT3
        DENAV3        => '0',                                                   -- ExcludeIf_DAVOUT3
        DENAC3        => '1',                                                   -- ExcludeIf_NotDACOUT3
        DENAC3        => '0',                                                   -- ExcludeIf_DACOUT3
        DENAT3        => '1',                                                   -- ExcludeIf_NotDATOUT3
        DENAT3        => '0',                                                   -- ExcludeIf_DATOUT3
        DENAV4        => '1',                                                   -- ExcludeIf_NotDAVOUT4
        DENAV4        => '0',                                                   -- ExcludeIf_DAVOUT4
        DENAC4        => '1',                                                   -- ExcludeIf_NotDACOUT4
        DENAC4        => '0',                                                   -- ExcludeIf_DACOUT4
        DENAT4        => '1',                                                   -- ExcludeIf_NotDATOUT4
        DENAT4        => '0',                                                   -- ExcludeIf_DATOUT4
        DENAV5        => '1',                                                   -- ExcludeIf_NotDAVOUT5
        DENAV5        => '0',                                                   -- ExcludeIf_DAVOUT5
        DENAC5        => '1',                                                   -- ExcludeIf_NotDACOUT5
        DENAC5        => '0',                                                   -- ExcludeIf_DACOUT5
        DENAT5        => '1',                                                   -- ExcludeIf_NotDATOUT5
        DENAT5        => '0',                                                   -- ExcludeIf_DATOUT5
        DENAV6        => '1',                                                   -- ExcludeIf_NotDAVOUT6
        DENAV6        => '0',                                                   -- ExcludeIf_DAVOUT6
        DENAC6        => '1',                                                   -- ExcludeIf_NotDACOUT6
        DENAC6        => '0',                                                   -- ExcludeIf_DACOUT6
        DENAT6        => '1',                                                   -- ExcludeIf_NotDATOUT6
        DENAT6        => '0',                                                   -- ExcludeIf_DATOUT6
        DENAV7        => '1',                                                   -- ExcludeIf_NotDAVOUT7
        DENAV7        => '0',                                                   -- ExcludeIf_DAVOUT7
        DENAC7        => '1',                                                   -- ExcludeIf_NotDACOUT7
        DENAC7        => '0',                                                   -- ExcludeIf_DACOUT7
        DENAT7        => '1',                                                   -- ExcludeIf_NotDATOUT7
        DENAT7        => '0',                                                   -- ExcludeIf_DATOUT7
        DENAV8        => '1',                                                   -- ExcludeIf_NotDAVOUT8
        DENAV8        => '0',                                                   -- ExcludeIf_DAVOUT8
        DENAC8        => '1',                                                   -- ExcludeIf_NotDACOUT8
        DENAC8        => '0',                                                   -- ExcludeIf_DACOUT8
        DENAT8        => '1',                                                   -- ExcludeIf_NotDATOUT8
        DENAT8        => '0',                                                   -- ExcludeIf_DATOUT8
        DENAV9        => '1',                                                   -- ExcludeIf_NotDAVOUT9
        DENAV9        => '0',                                                   -- ExcludeIf_DAVOUT9
        DENAC9        => '1',                                                   -- ExcludeIf_NotDACOUT9
        DENAC9        => '0',                                                   -- ExcludeIf_DACOUT9
        DENAT9        => '1',                                                   -- ExcludeIf_NotDATOUT9
        DENAT9        => '0',                                                   -- ExcludeIf_DATOUT9
        AV0           => AV0,                                                   -- ExcludeIf_NotAV0
        AV0           => '0',                                                   -- ExcludeIf_AV0
        AC0           => AC0,                                                   -- ExcludeIf_NotAC0
        AC0           => '0',                                                   -- ExcludeIf_AC0
        AT0           => AT0,                                                   -- ExcludeIf_NotAT0
        AT0           => '0',                                                   -- ExcludeIf_AT0
        AG0           => AG0,                                                   -- ExcludeIf_NotAG0
        AG0           => OPEN,                                                  -- ExcludeIf_AG0
        AV1           => AV1,                                                   -- ExcludeIf_NotAV1
        AV1           => '0',                                                   -- ExcludeIf_AV1
        AC1           => AC1,                                                   -- ExcludeIf_NotAC1
        AC1           => '0',                                                   -- ExcludeIf_AC1
        AT1           => AT1,                                                   -- ExcludeIf_NotAT1
        AT1           => '0',                                                   -- ExcludeIf_AT1
        AG1           => AG1,                                                   -- ExcludeIf_NotAG1
        AG1           => OPEN,                                                  -- ExcludeIf_AG1
        AV2           => AV2,                                                   -- ExcludeIf_NotAV2
        AV2           => '0',                                                   -- ExcludeIf_AV2
        AC2           => AC2,                                                   -- ExcludeIf_NotAC2
        AC2           => '0',                                                   -- ExcludeIf_AC2
        AT2           => AT2,                                                   -- ExcludeIf_NotAT2
        AT2           => '0',                                                   -- ExcludeIf_AT2
        AG2           => AG2,                                                   -- ExcludeIf_NotAG2
        AG2           => OPEN,                                                  -- ExcludeIf_AG2
        AV3           => AV3,                                                   -- ExcludeIf_NotAV3
        AV3           => '0',                                                   -- ExcludeIf_AV3
        AC3           => AC3,                                                   -- ExcludeIf_NotAC3
        AC3           => '0',                                                   -- ExcludeIf_AC3
        AT3           => AT3,                                                   -- ExcludeIf_NotAT3
        AT3           => '0',                                                   -- ExcludeIf_AT3
        AG3           => AG3,                                                   -- ExcludeIf_NotAG3
        AG3           => OPEN,                                                  -- ExcludeIf_AG3
        AV4           => AV4,                                                   -- ExcludeIf_NotAV4
        AV4           => '0',                                                   -- ExcludeIf_AV4
        AC4           => AC4,                                                   -- ExcludeIf_NotAC4
        AC4           => '0',                                                   -- ExcludeIf_AC4
        AT4           => AT4,                                                   -- ExcludeIf_NotAT4
        AT4           => '0',                                                   -- ExcludeIf_AT4
        AG4           => AG4,                                                   -- ExcludeIf_NotAG4
        AG4           => OPEN,                                                  -- ExcludeIf_AG4
        AV5           => AV5,                                                   -- ExcludeIf_NotAV5
        AV5           => '0',                                                   -- ExcludeIf_AV5
        AC5           => AC5,                                                   -- ExcludeIf_NotAC5
        AC5           => '0',                                                   -- ExcludeIf_AC5
        AT5           => AT5,                                                   -- ExcludeIf_NotAT5
        AT5           => '0',                                                   -- ExcludeIf_AT5
        AG5           => AG5,                                                   -- ExcludeIf_NotAG5
        AG5           => OPEN,                                                  -- ExcludeIf_AG5
        AV6           => AV6,                                                   -- ExcludeIf_NotAV6
        AV6           => '0',                                                   -- ExcludeIf_AV6
        AC6           => AC6,                                                   -- ExcludeIf_NotAC6
        AC6           => '0',                                                   -- ExcludeIf_AC6
        AT6           => AT6,                                                   -- ExcludeIf_NotAT6
        AT6           => '0',                                                   -- ExcludeIf_AT6
        AG6           => AG6,                                                   -- ExcludeIf_NotAG6
        AG6           => OPEN,                                                  -- ExcludeIf_AG6
        AV7           => AV7,                                                   -- ExcludeIf_NotAV7
        AV7           => '0',                                                   -- ExcludeIf_AV7
        AC7           => AC7,                                                   -- ExcludeIf_NotAC7
        AC7           => '0',                                                   -- ExcludeIf_AC7
        AT7           => AT7,                                                   -- ExcludeIf_NotAT7
        AT7           => '0',                                                   -- ExcludeIf_AT7
        AG7           => AG7,                                                   -- ExcludeIf_NotAG7
        AG7           => OPEN,                                                  -- ExcludeIf_AG7
        AV8           => AV8,                                                   -- ExcludeIf_NotAV8
        AV8           => '0',                                                   -- ExcludeIf_AV8
        AC8           => AC8,                                                   -- ExcludeIf_NotAC8
        AC8           => '0',                                                   -- ExcludeIf_AC8
        AT8           => AT8,                                                   -- ExcludeIf_NotAT8
        AT8           => '0',                                                   -- ExcludeIf_AT8
        AG8           => AG8,                                                   -- ExcludeIf_NotAG8
        AG8           => OPEN,                                                  -- ExcludeIf_AG8
        AV9           => AV9,                                                   -- ExcludeIf_NotAV9
        AV9           => '0',                                                   -- ExcludeIf_AV9
        AC9           => AC9,                                                   -- ExcludeIf_NotAC9
        AC9           => '0',                                                   -- ExcludeIf_AC9
        AT9           => AT9,                                                   -- ExcludeIf_NotAT9
        AT9           => '0',                                                   -- ExcludeIf_AT9
        AG9           => AG9,                                                   -- ExcludeIf_NotAG9
        AG9           => OPEN,                                                  -- ExcludeIf_AG9
        ATRETURN01    => ATRET01,                                               -- ExcludeIf_NotATRET01
        ATRETURN01    => '0',                                                   -- ExcludeIf_ATRET01
        ATRETURN23    => ATRET23,                                               -- ExcludeIf_NotATRET23
        ATRETURN23    => '0',                                                   -- ExcludeIf_ATRET23
        ATRETURN45    => ATRET45,                                               -- ExcludeIf_NotATRET45
        ATRETURN45    => '0',                                                   -- ExcludeIf_ATRET45
        ATRETURN67    => ATRET67,                                               -- ExcludeIf_NotATRET67
        ATRETURN67    => '0',                                                   -- ExcludeIf_ATRET67
        ATRETURN89    => ATRET89,                                               -- ExcludeIf_NotATRET89
        ATRETURN89    => '0',                                                   -- ExcludeIf_ATRET89
        VAREF         => VAREF,
        GNDREF        => '0',                                                   -- ExcludeIf_ExternalVref
        GNDREF        => GNDREF,                                                -- ExcludeIf_NotExternalVref
        GDON0         => GDON0,                                                 -- ExcludeIf_NotAG0
        GDON0         => '0',                                                   -- ExcludeIf_AG0
        GDON1         => GDON1,                                                 -- ExcludeIf_NotAG1
        GDON1         => '0',                                                   -- ExcludeIf_AG1
        GDON2         => GDON2,                                                 -- ExcludeIf_NotAG2
        GDON2         => '0',                                                   -- ExcludeIf_AG2
        GDON3         => GDON3,                                                 -- ExcludeIf_NotAG3
        GDON3         => '0',                                                   -- ExcludeIf_AG3
        GDON4         => GDON4,                                                 -- ExcludeIf_NotAG4
        GDON4         => '0',                                                   -- ExcludeIf_AG4
        GDON5         => GDON5,                                                 -- ExcludeIf_NotAG5
        GDON5         => '0',                                                   -- ExcludeIf_AG5
        GDON6         => GDON6,                                                 -- ExcludeIf_NotAG6
        GDON6         => '0',                                                   -- ExcludeIf_AG6
        GDON7         => GDON7,                                                 -- ExcludeIf_NotAG7
        GDON7         => '0',                                                   -- ExcludeIf_AG7
        GDON8         => GDON8,                                                 -- ExcludeIf_NotAG8
        GDON8         => '0',                                                   -- ExcludeIf_AG8
        GDON9         => GDON9,                                                 -- ExcludeIf_NotAG9
        GDON9         => '0',                                                   -- ExcludeIf_AG9
        CMSTB0        => '0',
        CMSTB1        => '0',
        CMSTB2        => '0',
        CMSTB3        => '0',
        CMSTB4        => '0',
        CMSTB5        => '0',
        CMSTB6        => '0',
        CMSTB7        => '0',
        CMSTB8        => '0',
        CMSTB9        => '0',
        TMSTB0        => '0',
        TMSTB1        => '0',
        TMSTB2        => '0',
        TMSTB3        => '0',
        TMSTB4        => '0',
        TMSTB5        => '0',
        TMSTB6        => '0',
        TMSTB7        => '0',
        TMSTB8        => '0',
        TMSTB9        => '0',
        TMSTBINT      => '0',
        RESULT        => RESULT,
        ACMRDATA      => OPEN,
        ACMWDATA      => Int_ACMWDATA,
        ACMADDR       => Int_ACMADDR,
        STC           => "ReplaceWith_STC",
        TVC           => "ReplaceWith_TVC",
        CHNUMBER      => CH_NUMBER,
        MODE          => "ReplaceWith_MODE",
        RTCXTLMODE    => OPEN,
        ACMRESET      => Int_ACMRESET,
        ACMCLK        => Int_ACMCLK,
        ACMWEN        => Int_ACMWE,
        VAREFSEL      => '0',                                                   -- ExcludeIf_ExternalVref
        VAREFSEL      => '1',                                                   -- ExcludeIf_NotExternalVref
        DATAVALID     => ADC_DONE,
        CALIBRATE     => OPEN,
        SAMPLE        => OPEN,
        BUSY          => OPEN,
        PWRDWN        => '0',
        SYSCLK        => SYS_CLK,
        ADCRESET      => SYS_RST,
        ADCSTART      => Int_ADCStart,
        RTCMATCH      => OPEN,
        RTCPSMMATCH   => OPEN,
        RTCXTLSEL     => OPEN,
        RTCCLK        => '0'
        );

    AB_INIT_CONFIG_Inst : AB_INIT_CONFIG
        Port Map(

            SYS_CLK   => SYS_CLK,
            SYS_RST   => SYS_RST,
            INIT_RUN  => Int_Init_Run,
            INIT_DONE => Int_Init_Done,
            ACMCLK    => Int_ACMCLK,
            ACMWE     => Int_ACMWE,
            ACMADDR   => Int_ACMADDR,
            ACMWDATA  => Int_ACMWDATA
            );

    Process( SYS_CLK, SYS_RST )
    Begin
        If ( SYS_RST = '1' ) Then
            Int_Count <= "0000000000000";
        ElsIf Rising_Edge( SYS_CLK ) Then
            Int_Count <= Int_Next_Count;
        End If;
    End Process;

    Process( SYS_CLK, SYS_RST )
    Begin
        If ( SYS_RST = '1' ) Then
            Int_Sys_Start  <= '0';
            Int_Next_Count <= "0000000000000";
        ElsIf Rising_Edge( SYS_CLK ) Then
            If ( Int_Count = "1111000000000" ) Then
                Int_Sys_Start  <= '1';
                Int_Next_Count <= "1111000000000";
            Else
                Int_Sys_Start  <= '0';
                Int_Next_Count <= Int_Count + 1;
            End If;
        End If;
    End Process;

    ADCSTART_PULSE : Process( SYS_CLK, SYS_RST )
    Begin
        If ( SYS_RST = '1' ) Then
            Int_ADCSTART1 <= '0';
            Int_ADCSTART2 <= '0';
        ElsIf Rising_Edge( SYS_CLK ) Then
            Int_ADCSTART1 <= ADC_START;
            Int_ADCSTART2 <= Int_ADCSTART1;
        End If;
    End Process;
    Int_ADCSTART <= ( Int_ADCSTART1 And Not Int_ADCSTART2 ) When State = Cap_Data Else '0';

    Process( SYS_CLK, SYS_RST )
    Begin
        If ( SYS_RST = '1' ) Then
            State <= Idle;
        ElsIf Rising_Edge( SYS_CLK ) Then
            State <= Next_State;
        End If;
    End Process;

    Process( SYS_RST, State, Int_Sys_Start, Int_Init_Done )
    Begin

        Next_State    <= State;
        Int_Init_Run  <= '0';

        Case State Is
            When Idle        => If ( Int_Sys_Start = '1' ) Then
                                    Next_State   <= Init_Sys;
                                    Int_Init_Run <= '1';
                                End If;
            When Init_Sys    => If ( Int_Init_Done = '1' ) Then
                                    Next_State   <= Cap_Data;
                                End If;
            When Cap_Data    => If ( SYS_RST = '1' ) Then
                                    Next_State    <= Idle;
                                End If;
            When Others => Next_State <= Idle;
        End Case;
    End Process;

    READY <= '1' When State = Cap_Data Else '0';

End RTL;



































