/**************************************************************************
**                                                                        *
**  FILE        :  wcscpy.c                                               *
**                                                                        *
**  DESCRIPTION :  Source file for wcscpy routine.                        *
**                 Copies s2 to s1.                                       *
**                 Returns s1.                                            *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wchar.h>

#ifdef WCHAR_SUPPORT_ENABLED

wchar_t *wcscpy(wchar_t * restrict s1, const wchar_t * restrict s2)
{
        wchar_t* os1    = s1;

        while ( (*os1++ = *s2++) )
        {
                /* No action */
                ;
        }

        return s1;
}

#endif
