/**************************************************************************
**                                                                        *
**  FILE        :  towlower.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for towlower routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

#undef towlower

/*
 * Convert an uppercase letter to the corresponding lowercase letter.
 * If the argument is a wide character for which iswupper is true and there
 * is a corresponding wide character for which iswlower is true, it will
 * return the corresponding wide character, otherwise, the argument is 
 * returned unchanged.
 */
wint_t towlower(wint_t wc)
{
        return towctrans(wc, _to_lower);
}

#endif
