/**************************************************************************
**                                                                        *
**  FILE        :  towctran.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for towctrans routine.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

/*
 * Map the wide character wc using the mapping described by desc.
 * Return the mapped value of wc using the mapping described by desc or
 * return the wide character wc unchanged in case of failure.
 */
wint_t towctrans(wint_t wc, wctrans_t desc)
{
        switch (desc)
        {
        case _to_lower:
                if (iswupper(wc))
                {
                        wc += 32;
                }
                break;
        case _to_upper:
                if (iswlower(wc))
                {
                        wc -= 32;
                }
        }

        return wc;
}

#endif
