/**************************************************************************
**                                                                        *
**  FILE        :  sqrt.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for sqrt() routine                         *
**                 Computes the 'square' root for the given value         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**  Based on Cephes Math Library Release 2.2:  June, 1992 ( Copyright     *
**  1984, 1987, 1988, 1992 by Stephen L. Moshier )                        *
**                                                                        *
**************************************************************************/

#include <math.h>
#include <errno.h>
#include <stdlib.h>
#include <float.h>
#include "fpbits.h"

#ifndef __SINGLE_FP__
#pragma alias   sqrtl   = _sqrt_dpf
#pragma alias   sqrt    = _sqrt_dpf
#endif

#ifndef SQRT2
/* sqrt(2) */
#define SQRT2 1.41421356237309504880
#endif

double
_sqrt_dpf( double arg )
{
        int     e;
        double  z, w;

        if ( arg <= 0.0 )
        {
                if ( arg < 0.0 )
                {
                        errno = EDOM;
#if _IEEE_754_FORMAT
                        {
                        double2longs_t  u;

                        u.s.lo = 0xffffffff;
                        u.s.hi = 0xffffffff;

                        return u.d;
                        }
#endif
                }
                return( 0.0 );
        }

        /* separate exponent and significand */
        z = frexp( arg, &e );

        w = arg;

        /* approximate square root of number between 0.5 and 1
         * relative error of approximation = 7.47e-3
         */
        arg = 4.173075996388649989089E-1 + 5.9016206709064458299663E-1 * z;

        /* adjust for odd powers of 2 */
        if ( e & 1 )
        {
                arg *= SQRT2;
                e--;
        }
        e /= 2;

        /* re-insert exponent */
        arg = ldexp( arg, e );

        /* Newton iterations: */
        arg = 0.5*(arg + w/arg);
        arg = 0.5*(arg + w/arg);
        arg = 0.5*(arg + w/arg);
        
        return(arg);

}
