/**************************************************************************
**                                                                        *
**  FILE        :  sin.c                                                  *
**                                                                        *
**  DESCRIPTION :  Source file for sin() routine                          *
**                 Computes the 'sinus' for the given angle (in radians)  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <math.h>

#ifdef __SINGLE_FP__
#pragma alias   sinl    = _sin_spf
#pragma alias   sin             = _sin_spf
#endif
#pragma alias   sinf    = _sin_spf


extern float _sinusf( float, int );

static
float
_sin_spf( float arg )
{
        return( _sinusf( arg, 0 ) );
}


