;;  setjmp.asm  ---  save environment in jmp_buf
;;
;;  FILE:               setjmp.asm
;;
;;  COPYRIGHT:          Copyright 2001-2009 Altium BV
;;
;;  DESCRIPTION:
;;
;;      The setjmp function saves its calling environment in
;;      its jmp_buf for later use by the longjmp function.
;;      If the return is from a direct invocation, the setjmp
;;      function returns zero. If the return is from a call to
;;      the longjmp, the setjmp function returns a nonzero
;;      value.
;;
;;      Buffer layout:
;;
;;      Offset          Register        Description
;;      --------------- --------------- -----------------------
;;      0x00            r15             setjmp() return address
;;      0x04            r1              stack pointer
;;      0x08            r2              callee saves register
;;      0x0C            r19             callee saves register
;;      0x10            r20             callee saves register
;;      0x14            r21             callee saves register
;;      0x18            r22             callee saves register
;;      0x1C            r23             callee saves register
;;      0x20            r24             callee saves register
;;      0x24            r25             callee saves register
;;      0x28            r26             callee saves register
;;      0x2C            r27             callee saves register
;;      0x30            r28             callee saves register
;;      0x34            r29             callee saves register
;;      0x38            r30             callee saves register
;;      0x3C            r31             callee saves register
;;

        .section        .text.libc
        .global         setjmp
setjmp: .label          code
        swi     r15,r3,0
        swi     r1,r3,4
        swi     r2,r3,8
        swi     r19,r3,12
        swi     r20,r3,16
        swi     r21,r3,20
        swi     r22,r3,24
        swi     r23,r3,28
        swi     r24,r3,32
        swi     r25,r3,36
        swi     r26,r3,40
        swi     r27,r3,44
        swi     r28,r3,48
        swi     r29,r3,52
        swi     r30,r3,56
        swi     r31,r3,60
        rtsd    r15,8
        addik   r3,r0,0
        .size   setjmp,$-setjmp

        .end
