;;  setjmp.asm  ---  load environment from jmp_buf
;;
;;  FILE:               longjmp.asm
;;
;;  COPYRIGHT:          Copyright 2001-2009 Altium BV
;;
;;  DESCRIPTION:
;;
;;      The longjmp function restores the environment saved by
;;      the most recent invocation of the program, with the
;;      corresponding jmp_buf argument. The longjmp function
;;      cause setjmp to return "val". The longjmp function
;;      cannot cause setjmp to return the value 0. If "val"
;;      is 0, then setjmp returns 1.
;;
;;      The buffer layout is described in: setjmp.asm

        .section        .text.libc
        .global         longjmp
longjmp:        .label  code
        bneid   r4,retv_ok                      ;; verify "val"
        lwi     r15,r3,0
        addik   r4,r0,1
retv_ok:
        lwi     r1,r3,4
        lwi     r2,r3,8
        lwi     r19,r3,12
        lwi     r20,r3,16
        lwi     r21,r3,20
        lwi     r22,r3,24
        lwi     r23,r3,28
        lwi     r24,r3,32
        lwi     r25,r3,36
        lwi     r26,r3,40
        lwi     r27,r3,44
        lwi     r28,r3,48
        lwi     r29,r3,52
        lwi     r30,r3,56
        lwi     r31,r3,60
        rtsd    r15,8
        addik   r3,r4,0
        .size   longjmp,$-longjmp

        .end
