/**************************************************************************
**                                                                        *
**  FILE        :  ldexpf.c                                               *
**                                                                        *
**  DESCRIPTION :  ldexp implementation for IEEE-754 single precision     *
**                 floating point format.                                 *
**                 Returns x * (2 to the power n)                         *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <errno.h>
#include <float.h>
#include <math.h>
#include "fpbits.h"

#if _IEEE_754_FORMAT
#ifdef __SINGLE_FP__
#pragma alias   ldexpl  = _ldexp_spf
#pragma alias   ldexp   = _ldexp_spf
#endif
#pragma alias   ldexpf  = _ldexp_spf

float
_ldexp_spf( float fr, int pwr )
{
        float2long_t    u;
        unsigned long   l;
        signed int      exp;

        /* this assumes that the float internally has the *same* endianess as the long */
        u.f     = fr;
        l       = u.l;

        exp     = (int)GET_FLOAT_EXPONENT( l ) + pwr;
        /* under/overflow test */
        if ( pwr > 2 * FLOAT_BIAS || exp > MAX_FLOAT_BIASED_EXP )
        {
                errno   = ERANGE;
                return copysignf( HUGE_VALF, fr );
        }
        if ( exp < MIN_FLOAT_BIASED_EXP )
        {
                /* no ERANGE required, since that's implementation defined */
                return copysignf( 0.0f, fr );
        }

        l       = PUT_FLOAT_EXPONENT( STRIP_FLOAT_EXPONENT( l ), exp );
        u.l     = l;

        return u.f;
}
#else
#endif /* _IEEE_754_FORMAT */
