/**************************************************************************
**                                                                        *
**  FILE        :  iswupper.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for iswupper routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

#undef iswupper

/*
 * Test for any wide character that corresponds to an uppercase letter or
 * is one of a locale-specific set of wide characters for which none of
 * iswcntrl, iswdigit, iswpunct or iswspace is true.
 * Return 0 on failure.
 */
int iswupper(wint_t wc)
{
        return iswctype(wc, _upper);
}

#endif
