/**************************************************************************
**                                                                        *
**  FILE        :  iswlower.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for iswlower routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

#undef iswlower

/*
 * Test for any wide character that corresponds to a lowercase letter or
 * is one of a locale-specific set of wide characters for which none of
 * iswcntrl, iswdigit, iswpunct or iswspace is true.
 * Return 0 on failure.
 */
int iswlower(wint_t wc)
{
        return iswctype(wc, _lower);
}

#endif
