/**************************************************************************
**                                                                        *
**  FILE        :  iswdigit.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for iswdigit routine.                      *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <wctype.h>

#ifdef WCHAR_SUPPORT_ENABLED

#undef iswdigit

/*
 * Test for for any wide character that corresponds to a decimal-digit
 * character.
 * Return 0 on failure.
 */
int iswdigit(wint_t wc)
{
        return iswctype(wc, _digit);
}

#endif
