/**************************************************************************
**                                                                        *
**  FILE        :  fwprintf.c                                             *
**                                                                        *
**  DESCRIPTION :  Source file for fwprintf() routine.                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <stdarg.h>
#include <wchar.h>
#include <io.h>

#ifdef WCHAR_SUPPORT_ENABLED

int fwprintf( FILE * restrict fp, const wchar_t * restrict format, ... )
{
        va_list ap;
        int     chars;

        va_start( ap, format );
        chars = _dowprint( (struct _io *)&fp, format, ap );
        va_end( ap );
        return (ferror(fp) ? EOF : chars);
}

#endif
