/**************************************************************************
**                                                                        *
**  FILE        :  difftime.c                                             *
**                                                                        *
**  DESCRIPTION :  The difftime function compute the difference between   *
**                 two calendar times.                                    *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/
#include <time.h>

double difftime( time_t time1, time_t time0 )
{
        signed long sdftime;
        unsigned long udftime;
        double retval;
        if ( time1 > time0 )
        {
                /*
                ** Positive result
                **
                ** time[12] can be bigger than a signed
                ** long can contain
                */
                udftime = time1 - time0;
                retval = (double)udftime;
        }
        else
        {
                /*
                ** negative result
                */
                sdftime = time1 - time0;
                retval = (double)sdftime;
        }
        
        return retval;
}
