/**************************************************************************
**                                                                        *
**  FILE        :  ctang.c                                                *
**                                                                        *
**  DESCRIPTION :  The ctan() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * ctan(z)
 *
 * Standard math
 *
 * = -i*ctanh(i*z)              ISO p.471
 */
extern  double complex          ctan(double complex z)
{
        return -__CDI*ctanh(__CDI*z);
}
