/**************************************************************************
**                                                                        *
**  FILE        :  csqrtg.c                                               *
**                                                                        *
**  DESCRIPTION :  The csqrt() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * csqrt(z)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */ 
extern  float complex           csqrtf(float complex z)
{
        float complex c;
        float x,y,w,r;
        if ((__cf_r(z) == 0.0f) && (__cf_i(z) == 0.0f))
        {
                c = z;
        }
        else
        {
                x = fabsf(__cf_r(z));
                y = fabsf(__cf_i(z));
                if (x >= y)
                {
                        r = y/x;
                        w = sqrtf(x)*sqrtf(0.5f*(1.0f+sqrtf(1.0+r*r)));
                }
                else
                {
                        r = x/y;
                        w = sqrtf(y)*sqrtf(0.5f*(r+sqrtf(1.0f+r*r)));
                }
                if (__cf_r(z) >= 0.0f)
                {
                        __cf_r(c) = w;
                        __cf_i(c) = __cf_i(z)/(2.0f*w);
                }
                else
                {
                        __cf_i(c) = (__cf_i(z) >= 0.0f) ? w : -w;
                        __cf_r(c) = __cf_i(z)/(2.0f*__cf_i(c));
                }
        }
        return c;
}
