/**************************************************************************
**                                                                        *
**  FILE        :  csqrtg.c                                               *
**                                                                        *
**  DESCRIPTION :  The csqrt() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * csqrt(z)
 *
 * See NR p.176 for explanation.
 * See NR p.949 for original source.
 */ 
extern  double complex          csqrt(double complex z)
{
        double complex c;
        double x,y,w,r;
        if ((__cd_r(z) == 0.0) && (__cd_i(z) == 0.0))
        {
                c = z;
        }
        else
        {
                x = fabs(__cd_r(z));
                y = fabs(__cd_i(z));
                if (x >= y)
                {
                        r = y/x;
                        w = sqrt(x)*sqrt(0.5*(1.0+sqrt(1.0+r*r)));
                }
                else
                {
                        r = x/y;
                        w = sqrt(y)*sqrt(0.5*(r+sqrt(1.0+r*r)));
                }
                if (__cd_r(z) >= 0.0)
                {
                        __cd_r(c) = w;
                        __cd_i(c) = __cd_i(z)/(2.0*w);
                }
                else
                {
                        __cd_i(c) = (__cd_i(z) >= 0.0) ? w : -w;
                        __cd_r(c) = __cd_i(z)/(2.0*__cd_i(c));
                }
        }
        return c;
}
