/**************************************************************************
**                                                                        *
**  FILE        :  csinhg.c                                               *
**                                                                        *
**  DESCRIPTION :  The csinh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * csinh(z)
 *
 *      = (exp(z)-exp(-z)/2     Edwards
 */
extern  float complex           csinhf(float complex z)
{
        return (cexpf(z)-cexpf(-z))/2.0f;
}
