/**************************************************************************
**                                                                        *
**  FILE        :  csing.c                                                *
**                                                                        *
**  DESCRIPTION :  The csin() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * csin(z)
 *
 *      = (exp(i*z)-exp(-i*z))/2i       calc
 *      = -i*csinh(i*z)                 ISO p.471
 */
extern  double complex          csin(double complex z)
{
        return -__CDI*csinh(__CDI*z);
}
