/**************************************************************************
**                                                                        *
**  FILE        :  cprojg.c                                               *
**                                                                        *
**  DESCRIPTION :  The cproj() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <float.h>
#include <math.h>
#include "fpbits.h"

/*
 * cproj(z)
 *
 * See ISO p.179.
 */
extern  long double complex             cprojl(long double complex z)
{
        if (isinf(__cld_r(z)) || isinf(__cld_i(z)))
        {
                long double complex c;
                __cld_r(c) = __long_double_infinity;
                __cld_i(c) = copysignl(0.0l,__cld_i(z));
                return c;
        }
        else
        {
                return z;
        }
}
