/**************************************************************************
**                                                                        *
**  FILE        :  cprojg.c                                               *
**                                                                        *
**  DESCRIPTION :  The cproj() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <float.h>
#include <math.h>
#include "fpbits.h"

/*
 * cproj(z)
 *
 * See ISO p.179.
 */
extern  double complex          cproj(double complex z)
{
        if (isinf(__cd_r(z)) || isinf(__cd_i(z)))
        {
                double complex c;
                __cd_r(c) = __double_infinity;
                __cd_i(c) = copysign(0.0,__cd_i(z));
                return c;
        }
        else
        {
                return z;
        }
}
