/**************************************************************************
**                                                                        *
**  FILE        :  clogg.c                                                *
**                                                                        *
**  DESCRIPTION :  The clog() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * clog(z)
 *
 * clog(a+ib)   = log(a*a+b*b)/2+i*atan2(b,a)   calc
 *              = log(sqrt(a*a+b*b))+i*atan2(b,a)
 *              = log(abs(a+ib))+i*atan2(b,a)
 *
 * Use last rewrite as abs has a good algorithm from NR.
 */
extern  float complex           clogf(float complex z)
{
        float complex c;
        __cf_r(c) = logf(cabsf(z));
        __cf_i(c) = atan2f(__cf_i(z),__cf_r(z));
        return c;
}
