/**************************************************************************
**                                                                        *
**  FILE        :  cexpg.c                                                *
**                                                                        *
**  DESCRIPTION :  The cexp() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * cexp(z)
 *
 * cexp(a+ib)   = exp(a)*(cos(b)+i*sin(b))      calc
 */
extern  long double complex             cexpl(long double complex z)
{
        long double complex c;
        long double tmp;
        tmp = expl(__cld_r(z));
        __cld_r(c) = tmp*cosl(__cld_i(z));
        __cld_i(c) = tmp*sinl(__cld_i(z));
        return c;
}
