/**************************************************************************
**                                                                        *
**  FILE        :  cexpg.c                                                *
**                                                                        *
**  DESCRIPTION :  The cexp() function.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>
#include <math.h>

/*
 * cexp(z)
 *
 * cexp(a+ib)   = exp(a)*(cos(b)+i*sin(b))      calc
 */
extern  double complex          cexp(double complex z)
{
        double complex c;
        double tmp;
        tmp = exp(__cd_r(z));
        __cd_r(c) = tmp*cos(__cd_i(z));
        __cd_i(c) = tmp*sin(__cd_i(z));
        return c;
}
