/**************************************************************************
**                                                                        *
**  FILE        :  ccoshg.c                                               *
**                                                                        *
**  DESCRIPTION :  The ccosh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * ccosh(z)
 *
 *      = (exp(z)+exp(-z))/2    Edwards
 */
extern  float complex           ccoshf(float complex z)
{
        return (cexpf(z)+cexpf(-z))/2.0f;
}
