/**************************************************************************
**                                                                        *
**  FILE        :  ccoshg.c                                               *
**                                                                        *
**  DESCRIPTION :  The ccosh() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * ccosh(z)
 *
 *      = (exp(z)+exp(-z))/2    Edwards
 */
extern  double complex          ccosh(double complex z)
{
        return (cexp(z)+cexp(-z))/2.0;
}
