/**************************************************************************
**                                                                        *
**  FILE        :  casing.c                                               *
**                                                                        *
**  DESCRIPTION :  The casin() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * casin(z)
 *
 *      = -i*log(i*z+sqrt(1-z*z))       mathwizards
 *      = -i*asinh(i*z)                 calc, ISO p.471
 */
extern  float complex           casinf(float complex z)
{
        return -__CFI*casinhf(__CFI*z);
}
