/**************************************************************************
**                                                                        *
**  FILE        :  cacosg.c                                               *
**                                                                        *
**  DESCRIPTION :  The cacos() function.                                  *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * cacos(z)
 *
 *      = -i*log(z+i*sqrt(1-z*z))       mathwizards
 *      = -i*log(z+sqrt(z*z-1))
 *      = -i*acosh(z)
 *
 *      Actually, according to ISO p.471 this is the only one that should
 *      not be reritten as a hyperbolic function because of special cases.
 *      Until we handle the special cases this is good enough though.
 */
extern  float complex           cacosf(float complex z)
{
        return -__CFI*cacoshf(z);
}
