/**************************************************************************
**                                                                        *
**  FILE        :  acos.c                                                 *
**                                                                        *
**  DESCRIPTION :  Source file for acos() routine                         *
**                 Computes the 'arccosinus' of the given value.          *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include        <math.h>
#include        <errno.h>

#ifdef __SINGLE_FP__
#pragma alias   acosl   = _acos_spf
#pragma alias   acos            = _acos_spf
#endif
#pragma alias   acosf   = _acos_spf


#define PIO2    1.570796326794896619231e0f

static
float
_acos_spf( float arg )
{
        if( ( arg > 1.0f ) || ( arg < -1.0f ) )
        {
                errno = EDOM;
                return( 0.0f );
        }

        return( PIO2 - asinf( arg ) );
}


