/**************************************************************************
**                                                                        *
**  FILE        :  _issubnormal.c                                         *
**                                                                        *
**  DESCRIPTION :  Determines if FP number is subnormal.                  *
**                 Does not test for NaN or infinity.                     *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <float.h>
#include "fpbits.h"

#ifndef __SINGLE_FP__
#pragma alias   _issubnormal            = _issubnormal_dpf
#pragma alias   _issubnormall           = _issubnormal_dpf
static
int     _issubnormal_dpf( double d )
{
        double2longs_t  u;
        unsigned long   hi;
        unsigned long   lo;

        /* double type acts as double */
        u.d     = d;
        hi      = u.s.hi;
        lo      = u.s.lo;

        return GET_DOUBLE_EXPONENT( hi ) == 0 &&
                ( GET_DOUBLE_HI_MANTISSA( hi ) || GET_DOUBLE_LO_MANTISSA( lo ) );
}
#endif
