/************************************************************************************************************
**
**  FILE        : _init.c
**
**  VERSION     : 1.11
**
**  DESCRIPTION :
**
**      Walk copy table, and execute appropriate actions.
**
**  Copyright 1996-2009 Altium BV                                         *
**
*************************************************************************************************************/

#include <stddef.h>
#include <start.h>

/* =========================================================
 * definitions
 * =========================================================
 */
typedef enum    action_s
{
        ac_stop         = 0,                                            /* no action, last entry in copy table                  */
        ac_copy         = 1,                                            /* copy <length> maus from <src> to <dst>               */
        ac_clear        = 2,                                            /* clear <length> maus at <dst>                         */
        ac_decompress   = 3,                                            /* decompress data from <src> to <dst>                  */
        ac_max
} action_t;

typedef struct  cptab_s
{
        action_t                  action;                               /* one of the actions listed above                      */
        __data const void       * src;                                  /* pointer to source memory block                       */
        __data void             * dst;                                  /* pointer to destination memory block                  */
        size_t                    length;                               /* # bytes involved in action                           */
} cptab_t;

/* =========================================================
 * external data
 * =========================================================
 */
extern  __no_sdata cptab_t _lc_ub_table[];                              /* start of copy table (defined in mb.lsl file)         */

/* =========================================================
 * implementation
 * =========================================================
 */

/************************************************************************************************************
 *
 *  FUNCTION:           _init
 *
 *  ENVIRONMENT:        --
 *
 *  REQUIREMENTS:       none
 *
 *  RETURN VALUE:       none
 *
 *  DESCRIPTION:
 *
 *      Walk copy table, and execute appropriate actions.
 *
 */

extern
void    _init( void )
{
        __data          cptab_t * entry;
        __data  const   void    * src;
        __data          void    * dst;
                        size_t    length;
                
        for ( entry = _lc_ub_table; ( entry->action & 3u ) != ac_stop ; entry++ )
        {
                src    = entry->src;
                dst    = entry->dst;
                length = entry->length;
                
                switch( entry->action & 3u )
                {
                case ac_copy:
                        _cptable_cpy( dst, src, length );
                        break;
                case ac_clear:
                        _cptable_clr( dst, length );
                        break;
                case ac_decompress:
                        _dcti( dst, src, length );
                        break;
                default:
                        break;
                }
        }
        return;
}
