/************************************************************************************************************
**
**  FILE        : _dcti.c
**
**  VERSION     : 1.1
**
**  DESCRIPTION :
**
**      Decompress binary compressed copy table item data.
**
**  Copyright 1996-2009 Altium BV                                         *
**
*************************************************************************************************************/

#include <start.h>

#define MAUSIZE         8
#ifndef MIN_LENGTH
#define MIN_LENGTH      2
#endif

static  int             read_bit( __data const unsigned char * __data * input, __data int * num_bits );
static  unsigned long   read_bits( const int n_bits,  __data const unsigned char * __data * input, __data int * num_bits );
static  unsigned long   read_delta( __data const unsigned char * __data * input, __data int * num_bits );
static  int             read_command( __data const unsigned char * __data * input, __data int * num_bits );

static
int             read_bit( __data const unsigned char *__data  * input, __data int * num_bits )
{
        int result;
        
        result = (**input >> (*num_bits)++) & 0x1;
        if ( *num_bits == MAUSIZE )
        {
                (*input)++;
                *num_bits = 0;
        }
        return result;
}

static
unsigned long   read_bits( const int n_bits, __data const unsigned char * __data * input, __data int * num_bits )
{
        unsigned long   rv = 0;
        int             i;

        for ( i = 0; i < n_bits; i++ )
        {
                rv <<= 1;
                rv += read_bit( input, num_bits );
        }
        return rv;
}

static
unsigned long   read_delta( __data const unsigned char * __data * input, __data int * num_bits )
{
        const   int             level = 4;
                unsigned long   rv    = 0;

        while ( read_bit( input, num_bits ) == 1 )
        {
                rv <<= level;
                rv |= read_bits( level, input, num_bits );
        }
        rv <<= level;
        rv |= read_bits( level, input, num_bits );
        return rv;      
}

static
int     read_command( __data const unsigned char * __data * input, __data int * num_bits )
{
        if ( read_bit( input, num_bits ) == 0 )
        {
                /* it's a shift */
                return read_bits( 8, input, num_bits );
        }
        else
        {
                /* it's a copy_length */
                int length = MIN_LENGTH;

                length += read_delta( input, num_bits );
                return -length;
        }
}

void    _dcti( __data unsigned char * dest, __data const unsigned char * src, size_t size )
{
        const   unsigned char * pos      = src;
                int             walk     = 0;
                int             num_bits = 0;
        
        while ( size > walk )
        {
                while ( 1 )
                {
                        int command = read_command( &pos, &num_bits );
                        
                        if ( command < 0 )
                        {
                                /* it's an offset */
                                int             length = -command;
                                unsigned long   delta  = read_delta( &pos, &num_bits );
                                int             i;
        
                                if ( delta == 0 )
                                {
                                        break;
                                }
                                for ( i = 0; i < length; i++ )
                                {
                                        dest[walk + i] = dest[walk - delta + i];
                                }
                                walk += length;
                        }
                        else
                        {
                                /* it's a shift */
                                dest[walk] = (unsigned char )command;
                                walk++;
                        }
                }
                if ( num_bits != 0 )
                {
                        pos++;
                        num_bits = 0;
                }
        }
        return;
}
