/**************************************************************************
**                                                                        *
**  FILE        :  _csubg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex subtraction.                                   *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>

/*
 * _csub(x,y)
 *
 * Element-wise subtraction.
 */
extern  double complex          _d_csub(double complex x, double complex y)
{
        double complex z;
        __cd_r(z) = __cd_r(x) - __cd_r(y);
        __cd_i(z) = __cd_i(x) - __cd_i(y);
        return z;
}
