/************************************************************************************************************
**
**  FILE        : _cptable_cpy.c
**
**  VERSION     : 1.3
**
**  DESCRIPTION :
**
**      Implements the copy-action from the copy table.
**
**  Copyright 1996-2009 Altium BV                                         *
**
*************************************************************************************************************/

#include <string.h>
#include <start.h>

/************************************************************************************************************
 *
 *  FUNCTION:           _cptable_cpy
 *
 *  ENVIRONMENT:        --
 *
 *  REQUIREMENTS:               __data void     *       dst     : destination location
 *                      const   __data void     *       src     : source location
 *                              size_t                  length  : # bytes to be copied
 *
 *  RETURN VALUE:       none
 *
 *  DESCRIPTION:
 *
 *      Copy <length> bytes from <src> to <dst>. Memory areas may not overlap.
 *
 */

extern
void    _cptable_cpy( __data void * dst, const __data void * src, size_t length )
{
        register char *so = dst;
        size_t n;
        
        for( n = 0; n < length; n++ )
        {
                *so++=*(char *)src, src = (char *)src + 1;
        }
        return;
}
