/************************************************************************************************************
**
**  FILE        : _cptable_clr.c
**
**  VERSION     : 1.3
**
**  DESCRIPTION :
**
**  Copyright 1996-2009 Altium BV                                         *
**
*************************************************************************************************************/

#include <string.h>
#include <start.h>

/************************************************************************************************************
 *
 *  FUNCTION:           _cptable_clr
 *
 *  ENVIRONMENT:        --
 *
 *  REQUIREMENTS:       __data  void            *       dst     : destination location
 *                              size_t                  length  : # bytes to be cleared
 *
 *  RETURN VALUE:       none
 *
 *  DESCRIPTION:
 *
 *      Clear <length> bytes, starting at <dst>.
 *
 */

extern
void    _cptable_clr( __data void * dst, size_t length )
{
        size_t  i;
        char *  so;

        so = (char *)dst;
        for ( i = 0;  i < length; i++ )
        {
                *so++ = 0;
        }
        return;
}
