/**************************************************************************
**                                                                        *
**  FILE        :  _cmulg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex multiplication.                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>


/*
 * _cmul(x,y)
 *
 * z = (x.r*y.i - x.i*y.i) + i(x.r*y.i + x.i*y.r)
 */
extern  long double complex             _ld_cmul(long double complex x, long double complex y)
{
        long double complex z;
        __cld_r(z) = __cld_r(x) * __cld_r(y) - __cld_i(x) * __cld_i(y);
        __cld_i(z) = __cld_r(x) * __cld_i(y) + __cld_i(x) * __cld_r(y);
        return z;
}
