/**************************************************************************
**                                                                        *
**  FILE        :  _cmulg.c                                               *
**                                                                        *
**  DESCRIPTION :  Complex multiplication.                                *
**                                                                        *
**  Copyright 1996-2009 Altium BV                                         *
**                                                                        *
**************************************************************************/

#include <complex.h>


/*
 * _cmul(x,y)
 *
 * z = (x.r*y.i - x.i*y.i) + i(x.r*y.i + x.i*y.r)
 */
extern  float complex           _f_cmul(float complex x, float complex y)
{
        float complex z;
        __cf_r(z) = __cf_r(x) * __cf_r(y) - __cf_i(x) * __cf_i(y);
        __cf_i(z) = __cf_r(x) * __cf_i(y) + __cf_i(x) * __cf_r(y);
        return z;
}
